﻿var timers = new Array();

function Timer(definition) {
    this.context = definition.parents(".timer");
    this.show = definition.data("show");
    this.type = definition.data("type");
    this.timeFormat = definition.data("timeformat");
    this.action = definition.data("action");
    this.secondToAction = definition.data("secondtoaction");
    this.hasExecutedAction = false;
    this.currentSeconds = this.secondToAction;

    this.firstClickInput = $(".FirstClickVariableName", this.context);
    this.lastClickInput = $(".LastClickVariableName", this.context);
    this.clickCountInput = $(".ClickCountVariableName", this.context);
    this.totalTimeInput = $(".TotalTimeVariableName", this.context);
}

Timer.prototype.prepareAction = function () {
    if (this.action == "enablenavigation") {
        $(".buttonContainer input").prop("disabled", true);
        $(".navigationBar").addClass('ui-disabled');
    } else if (this.action == "displaymessage") {
        $(".timerMessage", this.context).hide();
    }

    if (!this.show) {
        $(".questionContent", this.context).hide();

        if ($(".questionTextContainer label.questionText").length == 0)
            this.context.hide();
    }
}

Timer.prototype.start = function () {
    this.prepareAction();
    var timer = this;
    var counterSeconds = parseInt(this.totalTimeInput.val()) || 0;

    if (timer.show) {
        $(".timerTime", timer.context).html(timer.format(timer.type == "countup" ? counterSeconds : (timer.secondToAction - counterSeconds)));
    }

    if (timer.action == "autoadvance") {
        timer.secondToAction = timer.secondToAction + counterSeconds;
    }

    var counterInterval = setInterval(function () {
        counterSeconds++;

        timer.currentSeconds = counterSeconds;
        timer.totalTimeInput.val(counterSeconds);

        var seconds = 0;
        if (timer.type == "countup") {
            seconds = counterSeconds;
        } else {
            seconds = timer.secondToAction - counterSeconds;
        }

        if (timer.doExecuteAction()) {
            if (timer.isEnabled()) {
                timer.executeAction();
            }
        }

        if (timer.show) {
            $(".timerTime", timer.context).html(timer.format(seconds > 0 ? seconds : 0));
        }

    }, 1000);

}

Timer.prototype.doExecuteAction = function () {
    return !this.hasExecutedAction && (
        (this.type == "countup" && this.currentSeconds >= this.secondToAction)
        || (this.type == "countdown" && this.secondToAction - this.currentSeconds <= 0)
    );
}

Timer.prototype.executeAction = function () {
    //$(".timerTime", this.context).hide();
    this.hasExecutedAction = true;

    switch (this.action) {
        case "enablenavigation":
            $(".buttonContainer input").prop("disabled", false);
            $(".navigationBar").removeClass('ui-disabled');
            break;
        case "autoadvance":
            $(".nextButton").trigger("click");
            break;
        case "displaymessage":
            $(".timerMessage", this.context).show();
            break;
        case "terminatesurvey":
            var qid = this.context.parents(".questionBackground").data("logic-qid")
            window.location.replace(se.baseUrl + "exitsurvey.aspx?tqid=" + qid + "&noses=");
            break;
    }
}

Timer.prototype.format = function (totalSeconds) {
    var hours = parseInt(totalSeconds / 3600) % 24;
    var minutes = parseInt(totalSeconds / 60) % 60;
    var seconds = totalSeconds % 60;
    var time = this.timeFormat;

    time = time.replace("hh", hours < 10 ? "0" + hours : hours)
        .replace("mm", minutes < 10 ? "0" + minutes : minutes)
        .replace("ss", seconds < 10 ? "0" + seconds : seconds)

    return time;
}

Timer.prototype.updateClicks = function () {
    if (this.firstClickInput.val() == "") {
        this.firstClickInput.val(this.currentSeconds)
    }

    this.lastClickInput.val(this.currentSeconds)

    if (this.clickCountInput.val() == "")
        this.clickCountInput.val(1);
    else
        this.clickCountInput.val(parseInt(this.clickCountInput.val()) + 1);
}

Timer.prototype.isEnabled = function () {
    var questionContainer = this.context.parents(".questionBackground");
    return questionContainer.is(":visible");
}

Timer.prototype.hasEffectOnNavigation = function () {
    return this.action == "enablenavigation";
}

$(document).ready(function () {
    $(".timerDefinition").each(function () {
        timers.push(new Timer($(this)));
    });

    $.each(timers, function (key, timer) {
        if (timer.isEnabled())
            timer.start();
    });
});

if (document.addEventListener) { // For all major browsers, except IE 8 and earlier
    document.addEventListener('click', function (event) {
        $.each(timers, function (key, timer) {
            timer.updateClicks();
        });

    }, true);
} else
    if (document.attachEvent) { // For IE 8 and earlier versions                
        document.attachEvent('onclick', function (event) {
            $.each(timers, function (key, timer) {
                timer.updateClicks();
            });

        }, true);
    }

function refreshTimers() {
    var hasActiveTimer = false;

    $.each(timers, function (key, timer) {
        if (timer.isEnabled()) {
            timer.start();
            hasActiveTimer = hasActiveTimer || timer.hasEffectOnNavigation();
        }
    });

    if (!hasActiveTimer) {
        $(".buttonContainer input").prop("disabled", false);
    }
}